//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

	float GetNoise(vec2 pos){
	return fract(sin(dot(pos,vec2(12.9898,4.1414)))*43758.5453);
    }
    
vec3 DrawStars(inout vec3 color,vec3 viewPos){
	vec3 wpos=vec3(gbufferModelViewInverse*vec4(viewPos,1.));
	vec3 planeCoord=wpos/(wpos.y+length(wpos.xz));
	planeCoord.x+=.399;
	planeCoord.z+=0.;
	vec2 wind=vec2(frameTimeCounter,0.);
	vec2 coord=planeCoord.xz*DISTANCE_STARS+cameraPosition.xz*.0001+wind*.00125;
	coord=floor(coord*1024.)/1024.;
	
	float cosT=clamp(dot(normalize(viewPos), normalize(upVec)), 0.0, 1.0);
	float multiplier=sqrt(sqrt(cosT))*STARS_LIGHT_INTENSITY*(1.-rainStrengthS)*moonVisibility;
	
	float star=1.;
	if(cosT>0.){
		star*=GetNoise(coord.xy);
		star*=GetNoise(coord.xy+.115);
		star*=GetNoise(coord.xy+.230);
	}

	#if STARS_COVERAGE == 1
	float starsCov = 0.8125;
	#endif
	#if STARS_COVERAGE == 2
	float starsCov = 0.7125;
	#endif
	#if STARS_COVERAGE == 3
	float starsCov = 0.6125;
	#endif

	star=clamp(star - starsCov, 0.0, 1.0) * multiplier;
	star *= 1.0 - exp(- (10.0 - 9.0 * rainStrengthS) * cosT);
	
	color += star * pow(lightNight, vec3(0.8));
	return vec3(star);
}
